//  PCAN-ISO-TP.h
//
//  ~~~~~~~~~~~~
//
//  PCAN-ISO-TP API 2016 (ISO 15765-2:2016)
//
//  ~~~~~~~~~~~~
//
//  ------------------------------------------------------------------
//  Last changed by:	$Author: Fabrice $
//  Last changed date:	$Date: 2025-01-23 11:32:04 +0100 (Thu, 23 Jan 2025) $
//
//  Language: ANSI-C
//  ------------------------------------------------------------------
//
//  Copyright (C) 2015  PEAK-System Technik GmbH, Darmstadt
//  more Info at http://www.peak-system.com
//

#ifndef __PCANISOTP_DEFS_H__
#define __PCANISOTP_DEFS_H__

// Defines the version of the API based on the ISO revision
#define PCANTP_API_COMPATIBILITY_ISO_2004	2004
#define PCANTP_API_COMPATIBILITY_ISO_2016	2016

////////////////////////////////////////////
// Backward compatibility notes:
//	By default PCAN-ISO-TP API retains
//	PCAN-ISO-TP "ISO rev. 2004" (<2.x) prototypes.
//
//	To enable as default 2016 prototypes just define the macro PCANTP_API_COMPATIBILITY
//	before including PCAN-ISO-TP API headers.
//
//	Example:
//		#define PCANTP_API_COMPATIBILITY	PCANTP_API_COMPATIBILITY_ISO_2016
//		#include "PCAN-ISO-TP.h"
#if !defined(PCANTP_API_COMPATIBILITY)
#define PCANTP_API_COMPATIBILITY	PCANTP_API_COMPATIBILITY_ISO_2004
#endif

// >>> PCAN-ISO-TP 2.x backward compatibility
#if defined(PCANTP_API_COMPATIBILITY) && (PCANTP_API_COMPATIBILITY == PCANTP_API_COMPATIBILITY_ISO_2004)
	// Check types defined in Windows header (required by PCAN-ISO-TP_2004)
	#if !defined(BYTE) || !defined(WORD) || !defined(DWORD) || !defined(LPSTR) || !defined(UINT64)
		#ifdef __linux__
			#ifdef __cplusplus
				#include <cstdint>
			#else
				#include <stdint.h>
			#endif
			#ifndef __stdcall
				#define __stdcall
			#endif
			#ifndef BYTE
				#define BYTE uint8_t
			#endif
			#ifndef WORD
				#define WORD uint16_t
			#endif
			#ifndef DWORD
				#define DWORD uint32_t
			#endif
			#ifndef LPSTR
				#define LPSTR char*
			#endif
			#ifndef UINT64
				#define UINT64 uint64_t
			#endif
		#else
			#define WIN32_LEAN_AND_MEAN
			#include <windows.h>
		#endif
	#endif
	// Include header for ISO-15765-2:2004
	#include "PCAN-ISO-TP_2004.h"
#endif	// <<< PCAN-ISO-TP 2.x backward compatibility

// Include header for ISO-15765-2:2016
#include "PCAN-ISO-TP_2016.h"

#endif
